#include "nanovoid_app.h"

// inv_table_size should be Nx * Ny, while old_v and new_v should
// be Nx * Ny * 3
NanoVoidOneStep::NanoVoidOneStep(int _Nx, int _Ny, ParameterSet _p, valueType _lsh_r, uint _lshK, uint _lshL)
        :
        OneStep(vals_len, _Nx * _Ny * 3, _Nx * _Ny, _lshK, _lshL, _lsh_r),
        Nx(_Nx), Ny(_Ny), size(_Nx * _Ny), lshK(_lshK), lshL(_lshL),
        p(_p)
{
    p.energy_v0 = std::abs(p.energy_v0) + 0.001;
    p.energy_i0 = std::abs(p.energy_i0) + 0.001;
    p.kBT0 = std::abs(p.kBT0) + 0.001;
    p.kappa_v0 = std::abs(p.kappa_v0) + 0.001;
    p.kappa_i0 = std::abs(p.kappa_i0) + 0.001;
    p.kappa_eta0 = std::abs(p.kappa_eta0) + 0.001;
    p.r_bulk0 = std::abs(p.r_bulk0) + 0.001;
    p.r_surf0 = std::abs(p.r_surf0) + 0.001;

    p.p_casc0 = std::abs(p.p_casc0) + 0.001;
    p.bias0 = std::abs(p.bias0) + 0.001;
    p.vg0 = std::abs(p.vg0) + 0.001;
    p.diff_v0 = std::abs(p.diff_v0) + 0.001;
    p.diff_i0 = std::abs(p.diff_i0) + 0.001;
    p.L0 = std::abs(p.L0) + 0.001;
}


// organized in cv_0 ... cv_12, ci_0 ... ci_12, eta_0 ... eta_12
void NanoVoidOneStep::grab_vals(uint item, valueType *value_table, valueType *vals) {
    uint start_pos = 0;
    uint start_vals_pos = 0;
    uint i = 0, pg = 0;

    int c_x = item / Ny;
    int c_y = item % Ny;

    uint pd, root_item;
    int cc_x, cc_y;

    for (; i < lap_len_2nd; ++ i) {
        cc_x = c_x; cc_y = c_y;

        cc_x += dx[i];
        cc_y += dy[i];

        cc_x = max(cc_x, 0);      // smch: may be changed to mod operation
        cc_x = min(cc_x, Nx-1);
        cc_y = max(cc_y, 0);
        cc_y = min(cc_y, Ny-1);

        pd = inv.item2pd[((uint)cc_x)*Ny + ((uint)cc_y)];
        root_item = inv.d_item(inv.find_(pd));

        start_pos = 0;
        start_vals_pos = 0;

        for (pg = 0; pg < n_channels; ++ pg) {
            vals[start_vals_pos + i] = value_table[root_item + start_pos];
            start_pos += size;
            start_vals_pos += lap_len_2nd;
        }
    }

    // this is old version of using coordinate to grab vals
//    Coordinate2d3c c(0, 0);
//    c.from_item(item, size, size * size);
//
//    for (uint i = 0; i < lap_len_2nd; i++) {
//        Coordinate2d3c cc(c);
//
//        int x = cc.x + dx[i];
//        int y = cc.y + dy[i];
//
//        x = max(x, 0);
//        x = min(x, size - 1);
//        y = max(y, 0);
//        y = min(y, size - 1);
//
//        cc.x = x;
//        cc.y = y;
//
//        uint this_item_c1 = cc.to_item_c1(size, size * size);
////        uint this_item_c2 = cc.to_item_c2(size, size * size);
////        uint this_item_c3 = cc.to_item_c3(size, size * size);
//        // b here
//        uint pd1 = inv.item2pd[this_item_c1];
//        uint root1 = inv.find_(pd1);
//        uint root_item1 = inv.d_item(root1);
//        vals[i] = value_table[root_item1];
//
////        uint pd2 = inv.item2pd[this_item_c2];
////        uint root2 = inv.find_(pd2);
////        uint root_item2 = inv.d_item(root2);
//        vals[i + lap_len_2nd] = value_table[root_item1 + num_items];
//
////        uint pd3 = inv.item2pd[this_item_c3];
////        uint root3 = inv.find_(pd3);
////        uint root_item3 = inv.d_item(root3);
//        vals[i + lap_len_2nd * 2] = value_table[root_item1 + num_items * 2];
//    }
}

void NanoVoidOneStep::log_with_mask(valueType *mat, valueType eps, uint len) {
    for (uint i = 0; i < len; i++) {
        if (mat[i] < eps) {
            mat[i] = eps;
        }
        mat[i] = log(mat[i]);
    }
}

inline valueType NanoVoidOneStep::log_with_mask_single(valueType p, valueType eps) {
  /*if (p < eps) {
        p = eps;
  }*/
  //p = (p < eps ? eps : p);
  return log((p < eps ? eps : p));
}

void NanoVoidOneStep::masked_fill(valueType *mat, int *mask, valueType eps, uint len) {
    for (uint i = 0; i < len; i++) {
        if (mask[i] == 1) {
            mat[i] = eps;
        }
    }
}

// new_v are the value table, vals are grabbed from grab_vals
void NanoVoidOneStep::forward_one_step(valueType *vals, uint c, valueType *new_v) {
    valueType energy_v = std::abs(p.energy_v0);
    valueType energy_i = std::abs(p.energy_i0);
    valueType kBT = std::abs(p.kBT0);
    valueType kappa_v = std::abs(p.kappa_v0);
    valueType kappa_i = std::abs(p.kappa_i0);
    valueType kappa_eta = std::abs(p.kappa_eta0);
    valueType r_bulk = std::abs(p.r_bulk0);
    valueType r_surf = std::abs(p.r_surf0);

    valueType p_casc = std::abs(p.p_casc0);
    valueType bias = std::abs(p.bias0);
    valueType vg = std::abs(p.vg0);
    valueType diff_v = std::abs(p.diff_v0);
    valueType diff_i = std::abs(p.diff_i0);
    valueType L = std::abs(p.L0);

    // compute cv, ci
    valueType h_dfs_dcv[lap_len_1st];
    valueType h_dfs_dci[lap_len_1st];

    // construct h_dfs_dcv, h_dfs_dci
    for (uint i = 0; i < lap_len_1st; i++) {
        h_dfs_dcv[i] = 1.0;
        h_dfs_dci[i] = 1.0;

//        h_dfs_dcv[i] = (vals[lap_len_2nd * 2 + i] - 1) * (vals[lap_len_2nd * 2 + i] - 1); // (eta-1)**2
//        h_dfs_dci[i] = h_dfs_dcv[i];

        valueType log_cv = log_with_mask_single(vals[i], EPS);
        valueType log_ci = log_with_mask_single(vals[lap_len_2nd + i], EPS);
        valueType log_1_cv_ci = log_with_mask_single(1 - vals[i] - vals[i + lap_len_2nd], EPS);

        h_dfs_dcv[i] = h_dfs_dcv[i] * (energy_v + kBT * (log_cv - log_1_cv_ci));
        h_dfs_dci[i] = h_dfs_dci[i] * (energy_i + kBT * (log_ci - log_1_cv_ci));
        if ((1 - vals[i] - vals[i + lap_len_2nd]) < EPS) {
            h_dfs_dcv[i] = 0;
            h_dfs_dci[i] = 0;
        }

        h_dfs_dcv[i] = h_dfs_dcv[i] * (vals[lap_len_2nd * 2 + i] - 1) * (vals[lap_len_2nd * 2 + i] - 1); // (eta-1)**2
        h_dfs_dci[i] = h_dfs_dci[i] * (vals[lap_len_2nd * 2 + i] - 1) * (vals[lap_len_2nd * 2 + i] - 1);
    }

    valueType j_dfv_dcv[lap_len_1st];
    valueType j_dfv_dci[lap_len_1st];

    for (uint i = 0; i < lap_len_1st; i++) {
        j_dfv_dcv[i] = vals[lap_len_2nd * 2 + i] * vals[lap_len_2nd * 2 + i]; // eta**2
        j_dfv_dci[i] = j_dfv_dcv[i];

        j_dfv_dcv[i] = j_dfv_dcv[i] * 2 * (vals[i] - 1);
        j_dfv_dci[i] = j_dfv_dci[i] * 2 * vals[lap_len_2nd + i];
    }

    valueType dt = 1e-1;
    valueType mv = diff_v * vals[0] / kBT;
    valueType mi = diff_i * vals[lap_len_2nd] / kBT;

    valueType dt_mv_lap_h_dfs_dcv = dt * mv * inner_product(h_dfs_dcv, lapw, lap_len_1st);
    valueType dt_mv_lap_j_dfv_dcv = dt * mv * inner_product(j_dfv_dcv, lapw, lap_len_1st);
    valueType dt_mv_lap_lap_cv = - dt * mv * inner_product(vals, laplapw, lap_len_2nd);

    new_v[c] = vals[0] + dt_mv_lap_h_dfs_dcv + dt_mv_lap_j_dfv_dcv + kappa_v * dt_mv_lap_lap_cv;

    valueType dt_mi_lap_h_dfs_dci = dt * mi * inner_product(h_dfs_dci, lapw, lap_len_1st);
    valueType dt_mi_lap_j_dfv_dci = dt * mi * inner_product(j_dfv_dci, lapw, lap_len_1st);
    valueType dt_mi_lap_lap_ci = - dt * mi * inner_product(vals + lap_len_2nd, laplapw, lap_len_2nd);

    new_v[c + num_items] = vals[lap_len_2nd] + dt_mi_lap_h_dfs_dci + dt_mi_lap_j_dfv_dci + kappa_i * dt_mi_lap_lap_ci;

    // compute eta
    // fs
    valueType fs = energy_v * vals[0] + energy_i * vals[lap_len_2nd];
    fs = fs + kBT * (vals[0] * log_with_mask_single(vals[0], EPS));
    fs = fs + kBT * (vals[lap_len_2nd] * log_with_mask_single(vals[lap_len_2nd], EPS));
    fs = fs + kBT * ((1 - vals[0] - vals[lap_len_2nd]) * log_with_mask_single(1 - vals[0] - vals[lap_len_2nd], EPS));
    if ((1 - vals[0] - vals[lap_len_2nd]) < EPS) {
        fs = 0;
    }
    // fv
    valueType fv = (vals[0] - 1) * (vals[0] - 1) + vals[lap_len_2nd] * vals[lap_len_2nd];

    valueType dF_deta = N * (fs * 2 * (vals[lap_len_2nd*2] - 1) + fv * 2 * vals[lap_len_2nd*2] - \
            kappa_eta * inner_product(vals + lap_len_2nd*2, lapw, lap_len_1st));

    new_v[c + num_items * 2] = vals[lap_len_2nd*2] + dt * (-L) * dF_deta;

    if (std::signbit(new_v[c])) {
        new_v[c] = 0.0; //-new_v[c];
    }

    if (std::signbit(new_v[c + num_items])) {
        new_v[c + num_items] = 0.0; // -new_v[c + num_items];
    }

    if (std::signbit(new_v[c + num_items * 2])) {
        new_v[c + num_items * 2] = 0.0; // -new_v[c + num_items * 2];
    }

    if (new_v[c] >= 1.0) {
        new_v[c] = 1.0; //-new_v[c];
    }

    if (new_v[c + num_items] >= 1.0) {
        new_v[c + num_items] = 1.0; // -new_v[c + num_items];
    }

    if (new_v[c + num_items * 2] >= 1.0) {
        new_v[c + num_items * 2] = 1.0; // -new_v[c + num_items * 2];
    }

//    // compute ci
//    valueType h_dfs_dci[lap_len_1st];
//
//    for (uint i = 0; i < lap_len_1st; i++) {
//        h_dfs_dci[i] = (vals[lap_len_2nd * 2 + i] - 1) * (vals[lap_len_2nd * 2 + i] - 1); // (eta-1)**2
//        valueType log_ci = log_with_mask_single(vals[lap_len_2nd + i], EPS);
//    }
//
//    valueType j_dfv_dci[lap_len_1st];
}

/*
void NanoVoidOneStep::forward_one_step(valueType *vals, uint c, valueType *new_v) {

    // compute cv, ci
    valueType h_dfs_dcv[lap_len_1st];
    valueType h_dfs_dci[lap_len_1st];

    // construct h_dfs_dcv, h_dfs_dci
    for (uint i = 0; i < lap_len_1st; i++) {
        valueType log_cv = log_with_mask_single(vals[i], EPS);
        valueType log_ci = log_with_mask_single(vals[lap_len_2nd + i], EPS);
        valueType log_1_cv_ci = log_with_mask_single(1 - vals[i] - vals[i + lap_len_2nd], EPS);

        h_dfs_dcv[i] = (p.energy_v0 + p.kBT0 * (log_cv - log_1_cv_ci));
        h_dfs_dci[i] = (p.energy_i0 + p.kBT0 * (log_ci - log_1_cv_ci));
        if ((1 - vals[i] - vals[i + lap_len_2nd]) < EPS) {
            h_dfs_dcv[i] = 0;
            h_dfs_dci[i] = 0;
        }

        h_dfs_dcv[i] = h_dfs_dcv[i] * (vals[(lap_len_2nd<<1)+ i] - 1) * (vals[(lap_len_2nd<<2) + i] - 1); // (eta-1)**2
        h_dfs_dci[i] = h_dfs_dci[i] * (vals[(lap_len_2nd<<1) + i] - 1) * (vals[(lap_len_2nd<<1) + i] - 1);
    }

    valueType j_dfv_dcv[lap_len_1st];
    valueType j_dfv_dci[lap_len_1st];

    for (uint i = 0; i < lap_len_1st; i++) {
      j_dfv_dcv[i] = vals[(lap_len_2nd<<1) + i] * vals[(lap_len_2nd<<1) + i]; // eta**2
      j_dfv_dci[i] = j_dfv_dcv[i];

      j_dfv_dcv[i] = j_dfv_dcv[i] * 2 * (vals[i] - 1);
      j_dfv_dci[i] = j_dfv_dci[i] * 2 * vals[lap_len_2nd + i];
    }

    valueType dt = 1e-1;
    valueType mv = p.diff_v0 * vals[0] / p.kBT0;
    valueType mi = p.diff_i0 * vals[lap_len_2nd] / p.kBT0;

    valueType dt_mv_lap_h_dfs_dcv = dt * mv * inner_product(h_dfs_dcv, lapw, lap_len_1st);
    valueType dt_mv_lap_j_dfv_dcv = dt * mv * inner_product(j_dfv_dcv, lapw, lap_len_1st);
    valueType dt_mv_lap_lap_cv = - dt * mv * inner_product(vals, laplapw, lap_len_2nd);

    new_v[c] = vals[0] + dt_mv_lap_h_dfs_dcv + dt_mv_lap_j_dfv_dcv + p.kappa_v0 * dt_mv_lap_lap_cv;

    valueType dt_mi_lap_h_dfs_dci = dt * mi * inner_product(h_dfs_dci, lapw, lap_len_1st);
    valueType dt_mi_lap_j_dfv_dci = dt * mi * inner_product(j_dfv_dci, lapw, lap_len_1st);
    valueType dt_mi_lap_lap_ci = - dt * mi * inner_product(vals + lap_len_2nd, laplapw, lap_len_2nd);

    new_v[c + num_items] = vals[lap_len_2nd] + dt_mi_lap_h_dfs_dci + dt_mi_lap_j_dfv_dci + p.kappa_i0 * dt_mi_lap_lap_ci;

    // compute eta
    // fs
    valueType fs = p.energy_v0 * vals[0] + p.energy_i0 * vals[lap_len_2nd];
    fs += p.kBT0 * (vals[0] * log_with_mask_single(vals[0], EPS));
    fs += p.kBT0 * (vals[lap_len_2nd] * log_with_mask_single(vals[lap_len_2nd], EPS));
    fs += p.kBT0 * ((1 - vals[0] - vals[lap_len_2nd]) * log_with_mask_single(1 - vals[0] - vals[lap_len_2nd], EPS));
    if ((1 - vals[0] - vals[lap_len_2nd]) < EPS) {
        fs = 0;
    }
    // fv
    valueType fv = (vals[0] - 1) * (vals[0] - 1) + vals[lap_len_2nd] * vals[lap_len_2nd];

    valueType dF_deta = N * (fs * 2 * (vals[lap_len_2nd<<1] - 1) + fv * 2 * vals[lap_len_2nd<<1] - p.kappa_eta0 * inner_product(vals + (lap_len_2nd<<1), lapw, lap_len_1st));

    new_v[c + (num_items<<1)] = vals[(lap_len_2nd<<1)] + dt * (-p.L0) * dF_deta;

    new_v[c] = std::max(new_v[c], 0.0);
    new_v[c] = std::min(new_v[c], 1.0);

    new_v[c+num_items] = std::max(new_v[c+num_items], 0.0);
    new_v[c+num_items] = std::min(new_v[c+num_items], 1.0);
    
    new_v[c+(num_items<<1)] = std::max(new_v[c+(num_items<<1)], 0.0);
    new_v[c+(num_items<<1)] = std::min(new_v[c+(num_items<<1)], 1.0);

//    // compute ci
//    valueType h_dfs_dci[lap_len_1st];
//
//    for (uint i = 0; i < lap_len_1st; i++) {
//        h_dfs_dci[i] = (vals[lap_len_2nd * 2 + i] - 1) * (vals[lap_len_2nd * 2 + i] - 1); // (eta-1)**2
//        valueType log_ci = log_with_mask_single(vals[lap_len_2nd + i], EPS);
//    }
//
//    valueType j_dfv_dci[lap_len_1st];
}
*/


void NanoVoidOneStep::merge_neighbor_into_n_list(uint item, PNBucket *t) {
    Coordinate2d3c c(0, 0);
    c.from_item(item, Nx, size);

    uint root_item = t->p_list;
    uint root_pd = inv.item2pd[root_item];

    for (uint i = 0; i < lap_len_2nd; i++) {
        Coordinate2d3c cc(c);
        cc.x += dx[i];
        cc.y += dy[i];

        cc.x = max(cc.x, 0);
        cc.x = min(cc.x, Nx - 1);
        cc.y = max(cc.y, 0);
        cc.y = min(cc.y, Ny - 1);

        if (cc.x == c.x && cc.y == c.y)
            continue;

        uint this_item = cc.to_item_c1(Nx, size);
//        if ((t->n_list).find(this_item) != (t->n_list).end())
//            continue;
        // this does not need to be implemented; because we automatically ensure no duplication.

        uint pd = inv.item2pd[this_item];

        if (inv.find_(pd) != root_pd) {
            //            (t->n_list).insert(this_item);
            pnb.n_list_hash.insert_no_duplicate(t->n_list_id, this_item);
        }
    }

//    set<uint>::iterator it = (t->n_list).find(item);
//    if (it != (t->n_list).end())
//        (t->n_list).erase(it);
    uint item_hash;
    uint it = pnb.n_list_hash.find(t->n_list_id, item, item_hash);
    if (it != UINT_NULL)
        pnb.n_list_hash.delete_(it);
//    sort((t->n_list).begin(), (t->n_list).end());
//    vector<uint>::iterator last = unique((t->n_list).begin(), (t->n_list).end());
//    (t->n_list).resize(distance((t->n_list).begin(), last));
//
//    vector<uint>::iterator it = find((t->n_list).begin(), (t->n_list).end(), item);
//    if (it != (t->n_list).end())
//        (t->n_list).erase(it);
}

void NanoVoidOneStep::encode_from_img(valueType ***img) {
    Coordinate2d3c c(0, 0);
    for (c.x = 0; c.x < Nx; c.x++) {
        for (c.y = 0; c.y < Ny; c.y++) {
            uint item_1 = c.to_item_c1(Nx, size);
            uint item_2 = c.to_item_c2(Nx, size);
            uint item_3 = c.to_item_c3(Nx, size);
            old_v[item_1] = img[c.x][c.y][0];
            old_v[item_2] = img[c.x][c.y][1];
            old_v[item_3] = img[c.x][c.y][2];
        }
    }

    if (debug_on) {
        printf("after assign old_v\n");
        fflush(stdout);
    }

    // inv
    uint inv_size = (uint) size;
    for (uint i = 0; i < inv_size; i++) {
        inv.makeset(i);
    }

    if (debug_on)
        ;
//        inv.check_from_dfslist(num_items);

    valueType vals[vals_len];
    int item_lsh[lshK];
    uint item_k = 0, item = 0;

    uint handle_once = min(inv_size, (uint)1024*1024);

    uint item_vec[handle_once]; //[16777216]; //

    uint usize = inv_size;

    for (uint handle_start = 0; handle_start < usize; handle_start += handle_once) {
        if (debug_on) {
            printf("handle_start=%u\n", handle_start);
            fflush(stdout);
        }

        uint num_handled = min(usize - handle_start, handle_once);
        for (item_k = 0; item_k < num_handled; ++ item_k)
            item_vec[item_k] = handle_start + item_k;

        random_shuffle(item_vec, item_vec + num_handled);

        for (item_k = 0; item_k < num_handled; ++ item_k) {
            item = item_vec[item_k];
            grab_vals(item, old_v, vals);

            uint cl = 0;

            uint pnb_to_add = UINT_NULL;
            for (cl = 0; cl < L; ++ cl) {
                lsh.lsh(vals, cl, item_lsh);

                uint hp_it = hash_t.find(item_lsh, cl);
                if (hp_it != UINT_NULL) {
                    pnb_to_add = hash_t.hp.d[hp_it].pnb;
                    break;
                }
            }

            uint item_pd = inv.item2pd[item];
            PNBucket* pn_it = NULL;

            if (pnb_to_add != UINT_NULL) {
                pn_it = &(pnb.d[pnb_to_add]);
                uint ori_pn_plist = pn_it->p_list;
                uint pn_pd = inv.item2pd[pn_it->p_list];
                uint root = inv.union_(item_pd, pn_pd);
                pn_it->p_list = inv.d_item(root);

                if (pn_it->p_list != ori_pn_plist) {
                    for (cl = 0; cl < L; ++ cl) {
                        item2hp_hash.clear(item2hp_id[pn_it->p_list][cl]);
                        item2hp_hash.move_from_id_to_id(item2hp_id[ori_pn_plist][cl], \
                                            item2hp_id[pn_it->p_list][cl]);
                    }
                }
                merge_neighbor_into_n_list(item, pn_it);
            }
            else {
                pnb_to_add = pnb.new_elem();
                pn_it = &(pnb.d[pnb_to_add]);
                pn_it->p_list = item;
                //assert((pn_it->n_list).size() == 0);
                merge_neighbor_into_n_list(item, pn_it);
            }
            for (cl = 0; cl < L; ++ cl) {
                lsh.lsh(vals, cl, item_lsh);
                uint hp_it = hash_t.find(item_lsh, cl);
                if (hp_it == UINT_NULL || hash_t.hp.d[hp_it].pnb != pnb_to_add) {
                    uint hp_id = hash_t.hp.new_elem();
                    HashPointer* hp_it = &(hash_t.hp.d[hp_id]);
                    memcpy(hp_it->lsh_hash_code, item_lsh, sizeof(int)*K);
                    hp_it->hash_code = hash_t.hash_from_lsh(item_lsh);
                    hp_it->pnb = pnb_to_add;
                    hash_t.insert(hp_id, hp_it->hash_code, cl);
                    item2hp_hash.insert_no_duplicate(item2hp_id[pn_it->p_list][cl], hp_id);
                }
            }
        }
    }

    // v2 version of encoding
//    uint item_vec[num_items];
//    for (item_k = 0; item_k < num_items; ++ item_k) {
//        item_vec[item_k] = item_k;
//    }
//    random_shuffle(item_vec, item_vec + num_items);
//
//    for (item_k = 0; item_k < num_items; ++ item_k) {
//        item = item_vec[item_k];
//        //printf("encode item=%u\n", item);
//
//        grab_vals(item, old_v, vals);
//
//        uint cl = 0;
//        // determine if can add to other pnb;
//        uint pnb_to_add = UINT_NULL;
//        for (cl = 0; cl < L; ++ cl) {
//            lsh.lsh(vals, cl, item_lsh);
//
//            uint hp_it = hash_t.find(item_lsh, cl);
//            if (hp_it != UINT_NULL) {
//                pnb_to_add = hash_t.hp.d[hp_it].pnb;
//                break;
//            }
//        }
//
//        uint item_pd = inv.item2pd[item];
//        PNBucket* pn_it = NULL;
//        if (pnb_to_add != UINT_NULL) {
//            // merge into this bucket
//            pn_it = &(pnb.d[pnb_to_add]);
//            uint ori_pn_plist = pn_it->p_list;
//            uint pn_pd = inv.item2pd[pn_it->p_list];
//            uint root = inv.union_(item_pd, pn_pd);
//            pn_it->p_list = inv.d_item(root);
//
//            if (pn_it->p_list != ori_pn_plist) {
//                for (cl = 0; cl < L; ++ cl) {
//                    item2hp[pn_it->p_list][cl].clear();
//                    item2hp[pn_it->p_list][cl].insert(item2hp[ori_pn_plist][cl].begin(), \
//                                            item2hp[ori_pn_plist][cl].end());
//                    item2hp[ori_pn_plist][cl].clear();
//                }
//            }
//            // no need to update old_v (it is their accurate value).
//            merge_neighbor_into_n_list(item, pn_it);
//        }else{
//            pnb_to_add = pnb.new_elem();
//            pn_it = &(pnb.d[pnb_to_add]);
//            pn_it->p_list = item;
//            assert((pn_it->n_list).size() == 0);
//            merge_neighbor_into_n_list(item, pn_it);
//        }
//
//        for (cl = 0; cl < L; ++ cl) {
//            lsh.lsh(vals, cl, item_lsh);
//
//            uint hp_it = hash_t.find(item_lsh, cl);
//            if (hp_it == UINT_NULL) {
//                uint hp_id = hash_t.hp.new_elem();
//                HashPointer* hp_it = &(hash_t.hp.d[hp_id]);
//                std::memcpy(hp_it->lsh_hash_code, item_lsh, sizeof(int)*K);
//                hp_it->hash_code = hash_t.hash_from_lsh(item_lsh);
//                hp_it->pnb = pnb_to_add;
//                hash_t.insert(hp_id, hp_it->hash_code, cl);
//                item2hp[pn_it->p_list][cl].insert(hp_id);
//            }
//        }
//
//        if (item % Nx == 0) {
//            // printf("after processing %u items\n", item);
//            //hash_t.print_hash_table(inv);
//        }
//    }
//
//    inv.check_from_dfslist(this->num_items);


//    // item2bucket
//    for (uint i = 0; i < inv_size; i++) {
//        item2bucket[i] = NULL;
//    }

//    // hash each pixel
//    valueType vals[vals_len];
//    for (uint item = 0; item < inv_size; item++) {
//        grab_vals(item, old_v, vals);
//
//        int item_lsh = lsh.lsh(vals);
//        uint item_pd = inv.item2pd[item];
//
//        HashBucket* t_bucket = hash_t.find(item_lsh);
//        if (t_bucket != NULL) {
//            uint t_bucket_pd = inv.item2pd[t_bucket->p_list];
//            uint root = inv.union_(item_pd, t_bucket_pd);
//            t_bucket->p_list = inv.d_item(root);
//            item2bucket[t_bucket->p_list] = t_bucket;
//            merge_neighbor_into_n_list(item, t_bucket);
//        } else {
//            t_bucket = new HashBucket;
//            t_bucket->lsh_hash_code = item_lsh;
//            t_bucket->hash_code = hash_t.hash_from_lsh(item_lsh);
//            t_bucket->p_list = item;
//            item2bucket[t_bucket->p_list] = t_bucket;
//            assert((t_bucket->n_list).size() == 0);
//            merge_neighbor_into_n_list(item, t_bucket);
//            hash_t.insert(t_bucket, t_bucket->hash_code);
//        }
//
//        if (item % 1 == 0) {
//            if (debug_on)
//                printf("debugging info, item %u\n", item);
//        }
//    }
}

valueType ***NanoVoidOneStep::decode_to_img() {
    Coordinate2d3c c(0, 0);

    valueType*** mtx = new valueType**[Nx];
    for (c.x = 0; c.x < Nx; c.x++) {
        valueType** row = new valueType* [Nx];
        for (c.y = 0; c.y < Nx; c.y++) {
            uint item = c.to_item_c1(Nx, size);
            uint item_pd = inv.item2pd[item];
            uint root = inv.find_(item_pd);
            uint root_item = inv.d_item(root);
            valueType* channel_arr = new valueType[n_channels];
            for (uint channel = 0; channel < n_channels; channel++) {
                channel_arr[channel] = old_v[root_item + num_items * channel];
            }
            row[c.y] = channel_arr;
        }
        mtx[c.x] = row;
    }
    return mtx;
}

void NanoVoidOneStep::assign_vals(valueType *old_v, uint c_old, valueType *new_v, uint c_new) {
    uint start_pos = 0;
    c_new = c_new % size;
    c_old = c_old % size;
    for (uint pg = 0; pg < n_channels; ++ pg) {
        new_v[start_pos + c_new] = old_v[start_pos + c_old];
        start_pos += size;
    }

    // old version of using num_items as size
//    new_v[c_new % num_items] = old_v[c_old % num_items];
//    new_v[(c_new % num_items) + num_items] = old_v[(c_old % num_items) + num_items];
//    new_v[(c_new % num_items) + num_items * 2] = old_v[(c_old % num_items) + num_items * 2];
}

void NanoVoidOneStep::move_out_neighbor_from_n_list(uint item, PNBucket *t) {
    Coordinate2d3c c(0, 0);
    c.from_item(item, Nx, size);

    uint root_item = t->p_list;
    uint root_pd= inv.item2pd[root_item];

    for (uint i = 0; i < lap_len_2nd; i++) {
        Coordinate2d3c cc(c);
        cc.x += dx[i];
        cc.y += dy[i];

        cc.x = max(cc.x, 0);
        cc.x = min(cc.x, Nx-1);
        cc.y = max(cc.y, 0);
        cc.y = min(cc.y, Ny-1);

        if (cc.x == c.x && cc.y == c.y)
            continue;

//        vector< uint >::iterator cc_it = find((t->n_list).begin(), (t->n_list).end(), cc.to_item_c1(size, num_items));
//        set< uint >::iterator cc_it = (t->n_list).find(cc.to_item_c1(size, this->num_items));
//        if (cc_it == (t->n_list).end())
//            continue;
        uint cc_hash;
        uint cc_it = pnb.n_list_hash.find(t->n_list_id, cc.to_item_c1(Nx, size), cc_hash);
        if (cc_it == UINT_NULL)
            continue;

        // check its neighbor
        bool clean_out = true;
        for (uint j = 0; j < lap_len_2nd; j++) {
            Coordinate2d3c c3(cc);
            c3.x += dx[i];
            c3.y += dy[i];

            c3.x = max(c3.x, 0);
            c3.x = min(c3.x, Nx-1);
            c3.y = max(c3.y, 0);
            c3.y = min(c3.y, Ny-1);

            if (inv.find_(inv.item2pd[c3.to_item_c1(Nx, size)]) == root_pd) {
                clean_out = false;
                break;
            }
        }
        if (clean_out) {
//            (t->n_list).erase(cc_it);
            pnb.n_list_hash.delete_(cc_it);
        }
    }
//    if ((t->n_list).find(item) != (t->n_list).end())
//        return ;
    uint item_hash;
    uint item_it = pnb.n_list_hash.find(t->n_list_id, item, item_hash);
    if (item_it != UINT_NULL)
        return ;

    bool add_in = false;
    for (uint i = 0; i < lap_len_2nd; ++ i) {
        Coordinate2d3c cc(c);
        cc.x += dx[i];
        cc.y += dy[i];

        cc.x = max(cc.x, 0);
        cc.x = min(cc.x, Nx-1);
        cc.y = max(cc.y, 0);
        cc.y = min(cc.y, Ny-1);

        if (cc.x == c.x && cc.y == c.y)
            continue;

        if (inv.find_(inv.item2pd[cc.to_item_c1(Nx, size)]) == root_pd) {
            add_in = true;
            break;
        }
    }
    if (add_in){
//        (t->n_list).insert(item);
        pnb.n_list_hash.insert_(t->n_list_id, item, item_hash);
    }
}

// const valueType NanoVoidOneStep::lsh_r = 1e-4;

const int NanoVoidOneStep::dx[] = {0, 1, 0,-1, 0, 1,-1, 1,-1, 2, 0,-2, 0};
const int NanoVoidOneStep::dy[] = {0, 0, 1, 0,-1, 1, 1,-1,-1, 0, 2, 0,-2};
const valueType NanoVoidOneStep::laplapw[] = {20,-8,-8,-8,-8,2,2,2,2,1,1,1,1};
const valueType NanoVoidOneStep::lapw[] = {-4, 1, 1, 1, 1};

//const valueType NanoVoidOneStep::lsh = 1e-4;
//
//const int SpinodalDecompOneStep::dx[] = {0, 1, 0,-1, 0, 1,-1, 1,-1, 2, 0,-2, 0};
//const int SpinodalDecompOneStep::dy[] = {0, 0, 1, 0,-1, 1, 1,-1,-1, 0, 2, 0,-2};
//const valueType SpinodalDecompOneStep::laplapw[] = {20,-8,-8,-8,-8,2,2,2,2,1,1,1,1};
//const valueType SpinodalDecompOneStep::lapw[] = {-4, 1, 1, 1, 1};
